﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Npgsql;
    using Shared.DataFilters;
    using Shared.EntityModels;
    using Shared.Library.Enums;
    using Utilities;
    using Hims.Shared.UserModels.ProviderSchedule;
    using Hims.Shared.UserModels.Common;
    using Hims.Api.Models;
    using Hims.Shared.UserModels.Filters;

    /// <inheritdoc />
    [Authorize]
    [Route("api/provider-schedule")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class ProviderScheduleController : BaseController
    {
        /// <summary>
        /// The pdf reader services.
        /// </summary>
        private readonly IProviderScheduleService providerScheduleService;

        /// <summary>
        /// The audit log services.
        /// </summary>
        private readonly IAuditLogService auditLogServices;

        /// <inheritdoc />
        public ProviderScheduleController(IProviderScheduleService providerScheduleService, IAuditLogService auditLogServices)
        {
            this.providerScheduleService = providerScheduleService;
            this.auditLogServices = auditLogServices;
        }

        /// <summary>
        /// The fetch coupons.
        /// </summary>
        /// <param name="model"></param>
        /// <param name="header"></param>
        /// <returns>
        /// The list of coupons.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of coupons.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(409)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchAsync([FromBody] FilterModel model)
        {
            try
            {
                model = (FilterModel)EmptyFilter.Handler(model);
                //model.LocationId = (int)(!string.IsNullOrEmpty(header.LocationId) ? int.Parse(header.LocationId) : (int?)null);
                var providerSchedule = await this.providerScheduleService.FetchAsync(model);
                return  this.Success(providerSchedule);
            }
            catch (Exception ex)
            {
                _ = ex.Message.ToString();
            }
            return default;
        }


        /// <summary>
        /// The fetch coupons.
        /// </summary>
        /// <param name="model">
        /// The coupon filter model.
        /// </param>
        /// <param name="filter"></param>
        /// <returns>
        /// The list of coupons.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of coupons.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPut]
        [Route("fetch-events")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(409)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchEventAsync([FromBody] FilterModel model)
        {

            try
            {
                if (model.Filter == null)
                {
                    var providerScheduleEvent = await this.providerScheduleService.FetchEventAsync(model);
                    return this.Success(providerScheduleEvent);
                }
                else {
                    var filterEvent = await this.providerScheduleService.FetchFilterEvent(model);
                    return this.Success(filterEvent);
                }

            }
            catch (Exception ex)
            {
                _ = ex.Message.ToString();
            }
            return default;
        }


        /// <summary>
        /// The fetch coupons.
        /// </summary>
        /// <param name="model"></param>
        /// <param name="header"></param>
        /// <returns>
        /// The list of coupons.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of coupons.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Route("fetch-availability")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(409)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchAvailabilityScheduleAsync([FromBody] FilterModel model)
        {
            try
            {
                model = (FilterModel)EmptyFilter.Handler(model);
                //model.LocationId = (int)(!string.IsNullOrEmpty(header.LocationId) ? int.Parse(header.LocationId) : (int?)null);
                var providerSchedule = await this.providerScheduleService.FetchAvailabilityScheduleAsync(model);
                return this.Success(providerSchedule);
            }
            catch (Exception ex)
            {
                _ = ex.Message.ToString();
            }
            return default;
        }

    }
}